<?php
require_once '../config/config.php';
requireLogin();

$pdo = getDBConnection();
$message = '';
$error = '';

// Handle actions
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $action = $_POST['action'] ?? '';
    
    if ($action === 'delete_playlist') {
        $playlistId = intval($_POST['playlist_id']);
        
        try {
            // Get playlist info
            $stmt = $pdo->prepare("SELECT m3u_file_path FROM m3u_playlists WHERE id = ?");
            $stmt->execute([$playlistId]);
            $playlist = $stmt->fetch(PDO::FETCH_ASSOC);
            
            // Delete file if exists
            if ($playlist && file_exists($playlist['m3u_file_path'])) {
                unlink($playlist['m3u_file_path']);
            }
            
            // Delete from database
            $stmt = $pdo->prepare("DELETE FROM m3u_playlists WHERE id = ?");
            $stmt->execute([$playlistId]);
            $message = "Playlist deleted successfully.";
        } catch (Exception $e) {
            $error = "Error deleting playlist: " . $e->getMessage();
        }
    }
    
    elseif ($action === 'toggle_playlist_status') {
        $playlistId = intval($_POST['playlist_id']);
        $newStatus = intval($_POST['new_status']);
        
        try {
            $stmt = $pdo->prepare("UPDATE m3u_playlists SET is_active = ? WHERE id = ?");
            $stmt->execute([$newStatus, $playlistId]);
            $message = "Playlist status updated successfully.";
        } catch (Exception $e) {
            $error = "Error updating playlist status: " . $e->getMessage();
        }
    }
}

// Get all playlists
$playlists = $pdo->query("SELECT * FROM m3u_playlists ORDER BY created_at DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>M3U Playlists - Live TV Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .sidebar {
            background: linear-gradient(135deg, #8B0000 0%, #DC143C 100%);
            min-height: 100vh;
            color: white;
        }
        .sidebar .nav-link {
            color: rgba(255, 255, 255, 0.8);
            padding: 12px 20px;
            border-radius: 8px;
            margin: 5px 10px;
            transition: all 0.3s;
        }
        .sidebar .nav-link:hover, .sidebar .nav-link.active {
            color: white;
            background: rgba(255, 255, 255, 0.2);
            transform: translateX(5px);
        }
        .main-content {
            background: #000000;
            min-height: 100vh;
            color: white;
        }
        
        .main-content h1, .main-content h2, .main-content h3, .main-content h4, .main-content h5, .main-content h6 {
            color: white !important;
        }
        
        .main-content p, .main-content span, .main-content div {
            color: white !important;
        }
        
        .main-content .card-header {
            background: rgba(220, 20, 60, 0.2);
            color: white;
            border-bottom: 1px solid rgba(220, 20, 60, 0.3);
        }
        
        .main-content .card-body {
            background: rgba(255, 255, 255, 0.05);
            color: white;
        }
        
        .main-content .form-label {
            color: white !important;
        }
        
        .main-content .form-control {
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.3);
            color: white;
        }
        
        .main-content .form-control::placeholder {
            color: rgba(255, 255, 255, 0.7);
        }
        
        .main-content .form-select {
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.3);
            color: white;
        }
        
        .main-content .table {
            color: white;
        }
        
        .main-content .table th {
            color: white;
            border-color: rgba(255, 255, 255, 0.2);
        }
        
        .main-content .table td {
            color: white;
            border-color: rgba(255, 255, 255, 0.1);
        }
        
        .main-content .badge {
            color: white;
        }
        
        .main-content .btn-outline-primary {
            color: #DC143C;
            border-color: #DC143C;
        }
        
        .main-content .btn-outline-primary:hover {
            background-color: #DC143C;
            border-color: #DC143C;
            color: white;
        }
        
        .main-content .btn-outline-warning {
            color: #ffc107;
            border-color: #ffc107;
        }
        
        .main-content .btn-outline-warning:hover {
            background-color: #ffc107;
            border-color: #ffc107;
            color: black;
        }
        
        .main-content .btn-outline-success {
            color: #198754;
            border-color: #198754;
        }
        
        .main-content .btn-outline-success:hover {
            background-color: #198754;
            border-color: #198754;
            color: white;
        }
        
        .main-content .btn-outline-danger {
            color: #dc3545;
            border-color: #dc3545;
        }
        
        .main-content .btn-outline-danger:hover {
            background-color: #dc3545;
            border-color: #dc3545;
            color: white;
        }
        .card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
        }
        .btn-primary {
            background: linear-gradient(135deg, #8B0000 0%, #DC143C 100%);
            border: none;
            border-radius: 8px;
            padding: 10px 20px;
            font-weight: 600;
        }
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(139, 0, 0, 0.4);
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 px-0">
                <div class="sidebar">
                    <div class="p-3">
                        <h4><i class="fas fa-tv me-2"></i>Live TV Admin</h4>
                        <p class="text-light">Welcome, <?php echo $_SESSION['admin_username']; ?></p>
                    </div>
                    <nav class="nav flex-column">
                        <a class="nav-link" href="dashboard.php">
                            <i class="fas fa-tachometer-alt me-2"></i>Dashboard
                        </a>
                        <a class="nav-link" href="channels.php">
                            <i class="fas fa-tv me-2"></i>Manage Channels
                        </a>
                        <a class="nav-link" href="upload-m3u.php">
                            <i class="fas fa-upload me-2"></i>Upload M3U
                        </a>
                        <a class="nav-link active" href="playlists.php">
                            <i class="fas fa-list me-2"></i>M3U Playlists
                        </a>
                        <a class="nav-link" href="../index.php" target="_blank">
                            <i class="fas fa-external-link-alt me-2"></i>View Website
                        </a>
                        <a class="nav-link" href="logout.php">
                            <i class="fas fa-sign-out-alt me-2"></i>Logout
                        </a>
                    </nav>
                </div>
            </div>
            
            <!-- Main Content -->
            <div class="col-md-9 col-lg-10">
                <div class="main-content p-4">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h2><i class="fas fa-list me-2"></i>M3U Playlists</h2>
                        <div>
                            <a href="upload-m3u.php" class="btn btn-primary">
                                <i class="fas fa-plus me-2"></i>Add New Playlist
                            </a>
                        </div>
                    </div>
                    
                    <?php if ($message): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <i class="fas fa-check-circle me-2"></i><?php echo $message; ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?>
                    
                    <?php if ($error): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <i class="fas fa-exclamation-triangle me-2"></i><?php echo $error; ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?>
                    
                    <?php if (empty($playlists)): ?>
                        <div class="card">
                            <div class="card-body text-center py-5">
                                <i class="fas fa-list fa-4x text-muted mb-3"></i>
                                <h4 class="text-muted">No M3U Playlists Found</h4>
                                <p class="text-muted">Start by uploading your first M3U playlist.</p>
                                <a href="upload-m3u.php" class="btn btn-primary">
                                    <i class="fas fa-plus me-2"></i>Upload Your First Playlist
                                </a>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="card">
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>Name</th>
                                                <th>File Path</th>
                                                <th>Total Channels</th>
                                                <th>Status</th>
                                                <th>Created</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($playlists as $playlist): ?>
                                                <tr>
                                                    <td>
                                                        <strong><?php echo htmlspecialchars($playlist['name']); ?></strong>
                                                    </td>
                                                    <td>
                                                        <small class="text-muted">
                                                            <?php echo htmlspecialchars(basename($playlist['m3u_file_path'])); ?>
                                                        </small>
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-info">
                                                            <?php echo $playlist['total_channels']; ?> Channels
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <?php if ($playlist['is_active']): ?>
                                                            <span class="badge bg-success">Active</span>
                                                        <?php else: ?>
                                                            <span class="badge bg-danger">Inactive</span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <small class="text-muted">
                                                            <?php echo date('M j, Y', strtotime($playlist['created_at'])); ?>
                                                        </small>
                                                    </td>
                                                    <td>
                                                        <div class="btn-group" role="group">
                                                            <form method="POST" style="display: inline;">
                                                                <input type="hidden" name="action" value="toggle_playlist_status">
                                                                <input type="hidden" name="playlist_id" value="<?php echo $playlist['id']; ?>">
                                                                <input type="hidden" name="new_status" value="<?php echo $playlist['is_active'] ? 0 : 1; ?>">
                                                                <button type="submit" class="btn btn-sm btn-outline-<?php echo $playlist['is_active'] ? 'warning' : 'success'; ?>"
                                                                        onclick="return confirm('Are you sure you want to <?php echo $playlist['is_active'] ? 'deactivate' : 'activate'; ?> this playlist?')">
                                                                    <i class="fas fa-<?php echo $playlist['is_active'] ? 'pause' : 'play'; ?>"></i>
                                                                </button>
                                                            </form>
                                                            
                                                            <form method="POST" style="display: inline;">
                                                                <input type="hidden" name="action" value="delete_playlist">
                                                                <input type="hidden" name="playlist_id" value="<?php echo $playlist['id']; ?>">
                                                                <button type="submit" class="btn btn-sm btn-outline-danger"
                                                                        onclick="return confirm('Are you sure you want to delete this playlist? This action cannot be undone.')">
                                                                    <i class="fas fa-trash"></i>
                                                                </button>
                                                            </form>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
