<?php
require_once '../config/config.php';
requireLogin();

$pdo = getDBConnection();

// Get statistics
$totalChannels = $pdo->query("SELECT COUNT(*) FROM tv_channels")->fetchColumn();
$activeChannels = $pdo->query("SELECT COUNT(*) FROM tv_channels WHERE is_active = 1")->fetchColumn();
$totalPlaylists = $pdo->query("SELECT COUNT(*) FROM m3u_playlists")->fetchColumn();

// Get recent channels
$recentChannels = $pdo->query("SELECT * FROM tv_channels ORDER BY created_at DESC LIMIT 5")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - Live TV</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .sidebar {
            background: linear-gradient(135deg, #8B0000 0%, #DC143C 100%);
            min-height: 100vh;
            color: white;
        }
        .sidebar .nav-link {
            color: rgba(255, 255, 255, 0.8);
            padding: 12px 20px;
            border-radius: 8px;
            margin: 5px 10px;
            transition: all 0.3s;
        }
        .sidebar .nav-link:hover, .sidebar .nav-link.active {
            color: white;
            background: rgba(255, 255, 255, 0.2);
            transform: translateX(5px);
        }
        .stat-card {
            background: linear-gradient(135deg, #8B0000 0%, #DC143C 100%);
            color: white;
            border-radius: 15px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 10px 30px rgba(139, 0, 0, 0.3);
        }
        .stat-card h3 {
            font-size: 2.5rem;
            font-weight: bold;
            margin-bottom: 0.5rem;
        }
        .main-content {
            background: #000000;
            min-height: 100vh;
            color: white;
        }
        
        .main-content h1, .main-content h2, .main-content h3, .main-content h4, .main-content h5, .main-content h6 {
            color: white !important;
        }
        
        .main-content p, .main-content span, .main-content div {
            color: white !important;
        }
        
        .main-content .card-header {
            background: rgba(220, 20, 60, 0.2);
            color: white;
            border-bottom: 1px solid rgba(220, 20, 60, 0.3);
        }
        
        .main-content .card-body {
            background: rgba(255, 255, 255, 0.05);
            color: white;
        }
        
        .main-content .table {
            color: white;
        }
        
        .main-content .table th {
            color: white;
            border-color: rgba(255, 255, 255, 0.2);
        }
        
        .main-content .table td {
            color: white;
            border-color: rgba(255, 255, 255, 0.1);
        }
        .card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
        }
        .btn-primary {
            background: linear-gradient(135deg, #8B0000 0%, #DC143C 100%);
            border: none;
            border-radius: 8px;
            padding: 10px 20px;
            font-weight: 600;
        }
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(139, 0, 0, 0.4);
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 px-0">
                <div class="sidebar">
                    <div class="p-3">
                        <h4><i class="fas fa-tv me-2"></i>Live TV Admin</h4>
                        <p class="text-light">Welcome, <?php echo $_SESSION['admin_username']; ?></p>
                    </div>
                    <nav class="nav flex-column">
                        <a class="nav-link active" href="dashboard.php">
                            <i class="fas fa-tachometer-alt me-2"></i>Dashboard
                        </a>
                        <a class="nav-link" href="channels.php">
                            <i class="fas fa-tv me-2"></i>Manage Channels
                        </a>
                        <a class="nav-link" href="upload-m3u.php">
                            <i class="fas fa-upload me-2"></i>Upload M3U
                        </a>
                        <a class="nav-link" href="playlists.php">
                            <i class="fas fa-list me-2"></i>M3U Playlists
                        </a>
                        <a class="nav-link" href="../index.php" target="_blank">
                            <i class="fas fa-external-link-alt me-2"></i>View Website
                        </a>
                        <a class="nav-link" href="logout.php">
                            <i class="fas fa-sign-out-alt me-2"></i>Logout
                        </a>
                    </nav>
                </div>
            </div>
            
            <!-- Main Content -->
            <div class="col-md-9 col-lg-10">
                <div class="main-content p-4">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h2><i class="fas fa-tachometer-alt me-2"></i>Dashboard</h2>
                        <div>
                            <a href="upload-m3u.php" class="btn btn-primary">
                                <i class="fas fa-plus me-2"></i>Add New Channel
                            </a>
                        </div>
                    </div>
                    
                    <!-- Statistics Cards -->
                    <div class="row">
                        <div class="col-md-4">
                            <div class="stat-card">
                                <div class="d-flex align-items-center">
                                    <div class="flex-grow-1">
                                        <h3><?php echo $totalChannels; ?></h3>
                                        <p class="mb-0">Total Channels</p>
                                    </div>
                                    <i class="fas fa-tv fa-3x opacity-50"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="stat-card">
                                <div class="d-flex align-items-center">
                                    <div class="flex-grow-1">
                                        <h3><?php echo $activeChannels; ?></h3>
                                        <p class="mb-0">Active Channels</p>
                                    </div>
                                    <i class="fas fa-check-circle fa-3x opacity-50"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="stat-card">
                                <div class="d-flex align-items-center">
                                    <div class="flex-grow-1">
                                        <h3><?php echo $totalPlaylists; ?></h3>
                                        <p class="mb-0">M3U Playlists</p>
                                    </div>
                                    <i class="fas fa-list fa-3x opacity-50"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Recent Channels -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="mb-0"><i class="fas fa-clock me-2"></i>Recent Channels</h5>
                                </div>
                                <div class="card-body">
                                    <?php if (empty($recentChannels)): ?>
                                        <div class="text-center py-4">
                                            <i class="fas fa-tv fa-3x text-muted mb-3"></i>
                                            <p class="text-muted">No channels added yet</p>
                                            <a href="upload-m3u.php" class="btn btn-primary">
                                                <i class="fas fa-plus me-2"></i>Add Your First Channel
                                            </a>
                                        </div>
                                    <?php else: ?>
                                        <div class="table-responsive">
                                            <table class="table table-hover">
                                                <thead>
                                                    <tr>
                                                        <th>Logo</th>
                                                        <th>Channel Name</th>
                                                        <th>Category</th>
                                                        <th>Status</th>
                                                        <th>Added</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php foreach ($recentChannels as $channel): ?>
                                                        <tr>
                                                            <td>
                                                                <?php if ($channel['logo_url']): ?>
                                                                    <img src="../<?php echo $channel['logo_url']; ?>" 
                                                                         alt="<?php echo htmlspecialchars($channel['name']); ?>" 
                                                                         class="rounded" width="40" height="40">
                                                                <?php else: ?>
                                                                    <div class="bg-secondary rounded d-flex align-items-center justify-content-center" 
                                                                         style="width: 40px; height: 40px;">
                                                                        <i class="fas fa-tv text-white"></i>
                                                                    </div>
                                                                <?php endif; ?>
                                                            </td>
                                                            <td><?php echo htmlspecialchars($channel['name']); ?></td>
                                                            <td>
                                                                <span class="badge bg-info"><?php echo htmlspecialchars($channel['category'] ?? 'General'); ?></span>
                                                            </td>
                                                            <td>
                                                                <?php if ($channel['is_active']): ?>
                                                                    <span class="badge bg-success">Active</span>
                                                                <?php else: ?>
                                                                    <span class="badge bg-danger">Inactive</span>
                                                                <?php endif; ?>
                                                            </td>
                                                            <td><?php echo date('M j, Y', strtotime($channel['created_at'])); ?></td>
                                                        </tr>
                                                    <?php endforeach; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
