<?php
// Simple test to check if the configuration is working
echo "<h2>Live TV Configuration Test</h2>";

try {
    require_once 'config/config.php';
    echo "✅ Config loaded successfully<br>";
    
    $pdo = getDBConnection();
    echo "✅ Database connection successful<br>";
    
    // Test if tables exist
    $tables = $pdo->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
    $requiredTables = ['admin_users', 'tv_channels', 'm3u_playlists'];
    
    foreach ($requiredTables as $table) {
        if (in_array($table, $tables)) {
            echo "✅ Table '$table' exists<br>";
        } else {
            echo "❌ Table '$table' missing<br>";
        }
    }
    
    // Test upload directories
    $dirs = ['uploads', 'uploads/m3u', 'uploads/logos'];
    foreach ($dirs as $dir) {
        if (is_dir($dir)) {
            echo "✅ Directory '$dir' exists<br>";
        } else {
            echo "❌ Directory '$dir' missing<br>";
        }
    }
    
    echo "<br><strong>Setup Status:</strong> ";
    if (count($tables) >= 3 && is_dir('uploads')) {
        echo "✅ <span style='color: green;'>Ready to use!</span><br>";
        echo "<a href='index.php'>Go to Website</a> | <a href='admin/login.php'>Admin Panel</a>";
    } else {
        echo "❌ <span style='color: red;'>Setup incomplete</span><br>";
        echo "<a href='setup.php'>Run Setup</a>";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "<br>";
    echo "<a href='setup.php'>Run Setup</a>";
}
?>
