# Live TV Streaming Website

A complete live TV streaming website with admin panel for managing M3U playlists and TV channels.

## Features

### For Users
- 🎬 Watch live TV channels online
- 🔍 Search and filter channels by category
- 📱 Responsive design for all devices
- 🎥 Built-in video player with HLS support
- 🎨 Modern and beautiful UI

### For Admins
- 🔐 Secure admin authentication
- 📤 Upload M3U files and parse channels automatically
- 🔗 Import channels from M3U URLs
- ➕ Add individual channels manually
- 🖼️ Upload TV channel logos
- 📊 Dashboard with statistics
- ⚙️ Manage channel status (active/inactive)
- 🗑️ Delete channels
- ✏️ Edit channel information

## Installation

### Prerequisites
- XAMPP (Apache + MySQL + PHP)
- Web browser

### Setup Steps

1. **Download and Extract**
   - Extract all files to `C:\xampp\htdocs\tv\`

2. **Start XAMPP**
   - Start Apache and MySQL services

3. **Create Database**
   - Open phpMyAdmin (http://localhost/phpmyadmin)
   - Create a new database named `live_tv_db`
   - Import the `database.sql` file

4. **Run Setup**
   - Visit `http://localhost/tv/setup.php`
   - Follow the setup instructions

5. **Access the Website**
   - Main website: `http://localhost/tv/`
   - Admin panel: `http://localhost/tv/admin/login.php`

### Default Admin Credentials
- **Username:** admin
- **Password:** admin123

## Usage

### Adding Channels

#### Method 1: Upload M3U File
1. Login to admin panel
2. Go to "Upload M3U" page
3. Select your M3U file
4. Click "Upload & Parse M3U"
5. Channels will be automatically added

#### Method 2: Import from URL
1. Go to "Upload M3U" page
2. Enter M3U playlist URL
3. Click "Import from URL"
4. Channels will be imported automatically

#### Method 3: Add Single Channel
1. Go to "Upload M3U" page
2. Fill in channel details manually
3. Click "Add Channel"

### Managing Channels
- View all channels in "Manage Channels"
- Edit channel information
- Toggle active/inactive status
- Delete channels
- Upload channel logos

## File Structure

```
tv/
├── admin/                 # Admin panel files
│   ├── login.php         # Admin login
│   ├── dashboard.php     # Admin dashboard
│   ├── channels.php      # Channel management
│   └── upload-m3u.php    # M3U upload interface
├── config/               # Configuration files
│   ├── config.php        # Main configuration
│   └── database.php      # Database connection
├── includes/             # Include files
│   └── m3u_parser.php    # M3U parsing functionality
├── uploads/              # Upload directories
│   ├── m3u/             # M3U files
│   └── logos/           # Channel logos
├── index.php             # Main website
├── setup.php            # Setup script
├── database.sql         # Database structure
└── README.md            # This file
```

## Supported Formats

### M3U Playlist Formats
- Standard M3U files
- M3U8 (HLS) playlists
- Text files with stream URLs

### Video Stream Formats
- HLS (.m3u8)
- RTMP streams
- HTTP/HTTPS streams
- RTSP streams

## Browser Support

- Chrome (recommended)
- Firefox
- Safari (with native HLS support)
- Edge

## Security Features

- Password hashing for admin accounts
- SQL injection protection
- File upload validation
- Secure file storage
- Session management

## Troubleshooting

### Common Issues

1. **Database Connection Error**
   - Make sure MySQL is running in XAMPP
   - Check database name is `live_tv_db`
   - Verify database.sql was imported

2. **Channels Not Loading**
   - Check if channels are marked as active
   - Verify stream URLs are working
   - Check browser console for errors

3. **Video Not Playing**
   - Ensure stream URL is valid
   - Check if HLS.js is loading
   - Try different browser

4. **Upload Issues**
   - Check upload directory permissions
   - Verify file size limits
   - Ensure M3U file format is correct

### Support

For technical support or questions:
1. Check the setup.php page for system status
2. Verify all prerequisites are installed
3. Check XAMPP error logs
4. Ensure all files are properly uploaded

## License

This project is open source and available under the MIT License.

## Contributing

Feel free to contribute to this project by:
- Reporting bugs
- Suggesting new features
- Submitting pull requests
- Improving documentation

---

**Enjoy your Live TV Streaming Website!** 🎬📺
